package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 会员退货记录
 * @author zouhs
 * @date 2023/6/16
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MemberInfoComeBackRecord", description = "会员退货记录")
@Entity
@TableName("mms_member_info_come_back_record")
@Table(
    name = "mms_member_info_come_back_record",
    indexes = {
        @Index(name = "mms_member_info_come_back_record_index1", columnList = "member_code"),
        @Index(name = "mms_member_info_come_back_record_index2", columnList = "come_back_code")
    })
@org.hibernate.annotations.Table(appliesTo = "mms_member_info_come_back_record", comment = "会员退货记录")
public class MemberInfoComeBackRecord extends TenantFlagOpEntity {

    @ApiModelProperty("会员编码")
    @Column(name="member_code" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '会员编码'")
    private String memberCode;

    @ApiModelProperty("单据流水号")
    @Column(name="come_back_code" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '单据流水号'")
    private String comeBackCode;

    @ApiModelProperty("退货单位编码")
    @Column(name="customer_code", length = 100, columnDefinition = "VARCHAR(100) COMMENT '退货单位编码'")
    private String customerCode;

    @ApiModelProperty("退货单位")
    @Column(name="customer_name", length = 100, columnDefinition = "VARCHAR(100) COMMENT '退货单位'")
    private String customerName;

    @ApiModelProperty("收货单位编码")
    @Column(name="terminal_code", length = 100, columnDefinition = "VARCHAR(100) COMMENT '收货单位编码'")
    private String terminalCode;

    @ApiModelProperty("收货单位")
    @Column(name="terminal_name", length = 100, columnDefinition = "VARCHAR(100) COMMENT '收货单位'")
    private String terminalName;

    @ApiModelProperty("组织编码")
    @Column(name = "org_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '组织编码'")
    private String orgCode;

    @ApiModelProperty("组织名称")
    @Column(name = "org_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '组织名称'")
    private String orgName;

    @ApiModelProperty("单据时间")
    @TableField(value = "document_time")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "document_time", length = -1, columnDefinition = "datetime COMMENT '单据时间'")
    private String documentTime;

    @ApiModelProperty("退货时间")
    @TableField(value = "back_time")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "back_time", length = -1, columnDefinition = "datetime COMMENT '退货时间'")
    private String backTime;

    @ApiModelProperty("扣除成长值")
    @Column(name = "deduction_grow", length = 11, columnDefinition = "int(11) COMMENT '扣除成长值'")
    private Integer deductionGrow;

}


