package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 会员退货记录明细
 * @author zouhs
 * @date 2023/6/16
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MemberInfoComeBackRecordDetail", description = "会员退货记录明细")
@Entity
@TableName("mms_member_info_come_back_record_detail")
@Table(
    name = "mms_member_info_come_back_record_detail",
    indexes = {
        @Index(name = "mms_member_info_come_back_record_detail_index1", columnList = "come_back_code")
    })
@org.hibernate.annotations.Table(appliesTo = "mms_member_info_come_back_record_detail", comment = "会员退货记录明细")
public class MemberInfoComeBackRecordDetail extends TenantFlagOpEntity {

    @ApiModelProperty("单据流水号")
    @Column(name="come_back_code" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '单据流水号'")
    private String comeBackCode;

    @ApiModelProperty("产品编码")
    @Column(name="product_code" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '产品编码'")
    private String productCode;

    @ApiModelProperty("产品名称")
    @Column(name="product_name" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '产品名称'")
    private String productName;

    @ApiModelProperty("数量")
    @Column(name = "num", length = 11, columnDefinition = "int(11) COMMENT '数量'")
    private Integer num;

}


