package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 业务员联系人
 */
@Data
@Entity
@EqualsAndHashCode(callSuper = false)
@TableName("mms_member_info_contact")
@Table(
    name = "mms_member_info_contact",
    indexes = {
      @Index(name = "mms_member_info_contact_index1", columnList = "terminal_code")
    })
@org.hibernate.annotations.Table(appliesTo = "mms_member_info_contact", comment = "业务员联系人")
@ApiModel(value = "MemberInfoContact", description = "业务员联系人")
public class MemberInfoContact extends TenantFlagOpEntity {
  private static final long serialVersionUID = 438728535074328051L;

  @ApiModelProperty("会员编码")
  @Column(name="member_code" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '会员编码'")
  private String memberCode;

  /** 终端编码 */
  @ApiModelProperty("终端编码")
  @TableField(value = "terminal_code")
  @Column(name = "terminal_code", length = 64, columnDefinition = "varchar(64) COMMENT '终端编码'")
  private String terminalCode;

  /** 联系人姓名 */
  @ApiModelProperty("联系人姓名")
  @TableField(value = "contact_name")
  @Column(name = "contact_name", length = 64, columnDefinition = "varchar(64) COMMENT '联系人姓名'")
  private String contactName;

  /** 联系人电话 */
  @ApiModelProperty("联系人电话")
  @TableField(value = "contact_phone")
  @Column(name = "contact_phone", length = 64, columnDefinition = "varchar(64) COMMENT '联系人电话'")
  private String contactPhone;

  /** 主联系人,1是0否 */
  @ApiModelProperty("主联系人,true是false否")
  @TableField(value = "contact_main")
  @Column(name = "contact_main", columnDefinition = "int COMMENT '主联系人,1是0否'")
  private Boolean contactMain;

  /** 角色名称 */
  @ApiModelProperty("角色名称")
  @TableField(value = "role_name")
  @Column(name = "role_name", length = 64, columnDefinition = "varchar(64) COMMENT '角色名称'")
  private String roleName;

  /** 角色编码 */
  @ApiModelProperty("角色编码")
  @TableField(value = "role_code")
  @Column(name = "role_code", length = 64, columnDefinition = "varchar(64) COMMENT '角色编码'")
  private String roleCode;
}
