package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 会员成长值变动记录
 * @author zouhs
 * @date 2023/6/19
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MemberInfoGrowRecord", description = "会员成长值变动记录")
@Entity
@TableName("mms_member_info_grow_record")
@Table(
    name = "mms_member_info_grow_record",
    indexes = {
        @Index(name = "mms_member_info_grow_record_index1", columnList = "member_code"),
        @Index(name = "mms_member_info_grow_record_index2", columnList = "grow_code")
    })
@org.hibernate.annotations.Table(appliesTo = "mms_member_info_grow_record", comment = "会员成长值变动记录")
public class MemberInfoGrowRecord extends TenantFlagOpEntity {

  @ApiModelProperty("会员编码")
  @Column(name="member_code" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '会员编码'")
  private String memberCode;

  @ApiModelProperty("发放流水号")
  @Column(name="grow_code" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '发放流水号'")
  private String growCode;

  @ApiModelProperty("发放时间")
  @TableField(value = "opt_time")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "opt_time", length = -1, columnDefinition = "datetime COMMENT '发放时间'")
  private Date optTime;

  @ApiModelProperty("操作前数值")
  @Column(name = "before_grow", length = 11, columnDefinition = "int(11) COMMENT '操作前数值'")
  private Integer beforeGrow;

  @ApiModelProperty("成长值")
  @Column(name = "grow", length = 11, columnDefinition = "int(11) COMMENT '成长值'")
  private Integer grow;

  @ApiModelProperty("操作后数值")
  @Column(name = "after_grow", length = 11, columnDefinition = "int(11) COMMENT '操作后数值'")
  private Integer afterGrow;

  @ApiModelProperty("来源,枚举:mms_grow_resource,枚举类:GrowResourceEnum")
  @Column(name="source" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '来源'")
  private String source;

  @ApiModelProperty("发放流水号,对应签收/退货表里面的单据流水号")
  @Column(name="resource_document_code" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '发放流水号'")
  private String resourceDocumentCode;

  @ApiModelProperty("增加/减少,枚举,数据字典:mms_grow_operation,枚举类:GrowOperationEnum")
  @Column(name="operation_flag" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '增加/减少,枚举,数据字典:mms_grow_operation,枚举类:GrowOperationEnum'")
  private String operationFlag;
}
