package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 会员积分变动记录
 * @author zouhs
 * @date 2023/6/19
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MemberInfoIntegralRecord", description = "会员积分变动记录")
@Entity
@TableName("mms_member_info_integral_record")
@Table(
    name = "mms_member_info_integral_record",
    indexes = {
        @Index(name = "mms_member_info_integral_record_index1", columnList = "member_code"),
        @Index(name = "mms_member_info_integral_record_index2", columnList = "integral_code")
    })
@org.hibernate.annotations.Table(appliesTo = "mms_member_info_integral_record", comment = "会员积分变动记录")
public class MemberInfoIntegralRecord extends TenantFlagOpEntity {

  @ApiModelProperty("会员编码")
  @Column(name="member_code" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '会员编码'")
  private String memberCode;

  @ApiModelProperty("发放流水号")
  @Column(name="integral_code" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '发放流水号'")
  private String integralCode;

  @ApiModelProperty("发放时间")
  @TableField(value = "opt_time")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "opt_time", length = -1, columnDefinition = "datetime COMMENT '发放时间'")
  private Date optTime;

  @ApiModelProperty("操作前数值")
  @Column(name = "before_integral", length = 11, columnDefinition = "int(11) COMMENT '操作前数值'")
  private Integer beforeIntegral;

  @ApiModelProperty("积分")
  @Column(name = "integral", length = 11, columnDefinition = "int(11) COMMENT '积分'")
  private Integer integral;

  @ApiModelProperty("操作后数值")
  @Column(name = "after_integral", length = 11, columnDefinition = "int(11) COMMENT '操作后数值'")
  private Integer afterIntegral;

  @ApiModelProperty("来源,数据字典:mms_member_integral_source,枚举:IntegralSourceEnum")
  @Column(name="source" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '来源'")
  private String source;

  @ApiModelProperty("来源类型,数据字典:mms_member_integral_source_type,枚举:IntegralSourceEnum")
  @Column(name="type" , length = 20, columnDefinition = "VARCHAR(20) COMMENT '来源类型'")
  private String type;

  @ApiModelProperty("是否使用标记,枚举,数据字典mms_member_info_integral_use_status,枚举类MemberInfoIntegralUseStatusEnum")
  @Column(name="flag_use" , length = 32, columnDefinition = "VARCHAR(32) COMMENT '是否使用标记'")
  private String flagUse;

  @ApiModelProperty("此次获得的积分中还剩余的积分")
  @Column(name = "residual_integral", length = 11, columnDefinition = "int(11) COMMENT '此次获得的积分中还剩余的积分'")
  private Integer residualIntegral;
}
