package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 会员等级变动记录
 * @author zouhs
 * @date 2023/6/19
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MemberInfoLevelChangeRecord", description = "会员等级变动记录")
@Entity
@TableName("mms_member_info_level_change_record")
@Table(
    name = "mms_member_info_level_change_record",
    indexes = {
        @Index(name = "mms_member_info_level_change_record_index1", columnList = "member_code"),
    })
@org.hibernate.annotations.Table(appliesTo = "mms_member_info_level_change_record", comment = "会员等级变动记录")
public class MemberInfoLevelChangeRecord extends TenantFlagOpEntity {

  @ApiModelProperty("会员编码")
  @Column(name="member_code" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '会员编码'")
  private String memberCode;

  @ApiModelProperty("等级编码")
  @Column(name = "level_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '等级编码'")
  private String levelCode;

  @ApiModelProperty("等级名称")
  @Column(name = "level_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '等级名称'")
  private String levelName;

}
