package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 会员签收记录
 * @author zouhs
 * @date 2023/6/16
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MemberInfoReceiptRecord", description = "会员签收记录")
@Entity
@TableName("mms_member_info_receipt_record")
@Table(
    name = "mms_member_info_receipt_record",
    indexes = {
        @Index(name = "mms_member_info_receipt_record_index1", columnList = "member_code"),
        @Index(name = "mms_member_info_receipt_record_index2", columnList = "receipt_code")
    })
@org.hibernate.annotations.Table(appliesTo = "mms_member_info_receipt_record", comment = "会员签收记录")
public class MemberInfoReceiptRecord extends TenantFlagOpEntity {

    @ApiModelProperty("会员编码")
    @Column(name="member_code" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '会员编码'")
    private String memberCode;

    @ApiModelProperty("单据流水号")
    @Column(name="receipt_code" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '单据流水号'")
    private String receiptCode;

    @ApiModelProperty("发货单位编码")
    @Column(name="customer_code", length = 100, columnDefinition = "VARCHAR(100) COMMENT '发货单位编码'")
    private String customerCode;

    @ApiModelProperty("发货单位")
    @Column(name="customer_name", length = 100, columnDefinition = "VARCHAR(100) COMMENT '发货单位'")
    private String customerName;

    @ApiModelProperty("收货单位编码")
    @Column(name="terminal_code", length = 100, columnDefinition = "VARCHAR(100) COMMENT '收货单位编码'")
    private String terminalCode;

    @ApiModelProperty("收货单位")
    @Column(name="terminal_name", length = 100, columnDefinition = "VARCHAR(100) COMMENT '收货单位'")
    private String terminalName;

    @ApiModelProperty("组织编码")
    @Column(name = "org_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '组织编码'")
    private String orgCode;

    @ApiModelProperty("组织名称")
    @Column(name = "org_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '组织名称'")
    private String orgName;

    @ApiModelProperty("单据时间")
    @TableField(value = "document_time")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "document_time", length = -1, columnDefinition = "datetime COMMENT '单据时间'")
    private Date documentTime;

    @ApiModelProperty("签收时间")
    @TableField(value = "receipt_time")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "receipt_time", length = -1, columnDefinition = "datetime COMMENT '签收时间'")
    private Date receiptTime;

    @ApiModelProperty("签收地点")
    @Column(name="receipt_addr", length = 225, columnDefinition = "VARCHAR(225) COMMENT '签收地点'")
    private String receiptAddr;

    @ApiModelProperty("获得成长值")
    @Column(name = "get_grow", length = 11, columnDefinition = "int(11) COMMENT '获得成长值'")
    private Integer getGrow;

}


