package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 会员签到表
 * @author zouhs
 * @date 2023/6/27
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MemberInfoSign", description = "会员签到表")
@Entity
@TableName("mms_member_info_sign")
@Table(
    name = "mms_member_info_sign",
    indexes = {
        @Index(name = "mms_member_info_sign_index1", columnList = "member_code"),
    })
@org.hibernate.annotations.Table(appliesTo = "mms_member_info_sign", comment = "会员签到表")
public class MemberInfoSign extends TenantFlagOpEntity {

  @ApiModelProperty("会员编码")
  @Column(name="member_code" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '会员编码'")
  private String memberCode;

  @ApiModelProperty("签到编码")
  @Column(name="sign_code" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '签到编码'")
  private String signCode;

  @ApiModelProperty("签到时间")
  @TableField(value = "sign_time")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "sign_time", length = -1, columnDefinition = "datetime COMMENT '签到时间'")
  private Date signTime;

  @ApiModelProperty("真实积分")
  @Column(name = "integral", length = 11, columnDefinition = "int(11) COMMENT '真实积分'")
  private Integer integral;

  @ApiModelProperty("连续签到天数")
  @Column(name = "continue_day", length = 1, columnDefinition = "tinyint(1) COMMENT '连续签到天数'")
  private Integer continueDay;

  @ApiModelProperty("连续签到额外获取到的积分")
  @Column(name = "extend_obtain", length = 11, columnDefinition = "int(11) COMMENT '连续签到额外获取到的积分'")
  private Integer extendObtain;
}
