package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Data;
import lombok.EqualsAndHashCode;


@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mms_member_info_supply")
@Table(
    name = "mms_member_info_supply",
    indexes = {
      @Index(name = "mms_member_info_supply_index1", columnList = "terminal_code"),
    })
@org.hibernate.annotations.Table(appliesTo = "mms_member_info_supply", comment = "采供关系")
@ApiModel(value = "MemberInfoSupply", description = "采供关系")
public class MemberInfoSupply extends TenantFlagOpEntity {
  private static final long serialVersionUID = -8611254580674041546L;


  /** 终端编码 */
  @ApiModelProperty("终端编码")
  @TableField(value = "terminal_code")
  @Column(name = "terminal_code", length = 64, columnDefinition = "varchar(64) COMMENT '终端编码'")
  private String terminalCode;

  /** 组织编码 */
  @ApiModelProperty("组织编码")
  @TableField(value = "org_code")
  @Column(name = "org_code", length = 64, columnDefinition = "varchar(64) COMMENT '组织编码'")
  private String orgCode;

  @ApiModelProperty("组织名称")
  @TableField(value = "org_name")
  @Column(name = "org_name", length = 64, columnDefinition = "varchar(64) COMMENT '组织名称'")
  private String orgName;

  /** 供货单位编码 */
  @ApiModelProperty("供货单位编码")
  @TableField(value = "supply_code")
  @Column(name = "supply_code", length = 64, columnDefinition = "varchar(64) COMMENT '供货单位编码'")
  private String supplyCode;

  /** 供货单位名称 */
  @ApiModelProperty("供货单位名称")
  @TableField(value = "supply_name")
  @Column(name = "supply_name", length = 64, columnDefinition = "varchar(64) COMMENT '供货单位名称'")
  private String supplyName;


}
