package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mms_member_info_tag")
@Table(
    name = "mms_member_info_tag",
    indexes = {
        @Index(name = "mms_member_info_tag_index1", columnList = "terminal_code"),
        @Index(name = "mms_member_info_tag_index2", columnList = "member_code")
    })
@ApiModel(value = "MemberInfoTag", description = "会员标签")
@org.hibernate.annotations.Table(appliesTo = "mms_member_info_tag", comment = "会员标签")
public class MemberInfoTag extends TenantFlagOpEntity {

  private static final long serialVersionUID = -1642701831123818333L;

  @ApiModelProperty("会员编码")
  @Column(name="member_code" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '会员编码'")
  private String memberCode;

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  @TableField(value = "terminal_code")
  @Column(name = "terminal_code", length = 32, columnDefinition = "varchar(32) COMMENT '终端编码'")
  private String terminalCode;

  /**
   * 标签类型
   */
  @ApiModelProperty("标签类型")
  @TableField(value = "tag_type")
  @Column(name = "tag_type", length = 2, columnDefinition = "varchar(2) COMMENT '标签类型'")
  private String tagType;

  @ApiModelProperty("标签名称")
  @Column(
      name = "tag_name",
      length = 64,
      columnDefinition = "VARCHAR(64) COMMENT '标签名称'")
  private String tagName;

  @ApiModelProperty("标签编码")
  @Column(
      name = "tag_code",
      length = 64,
      columnDefinition = "VARCHAR(64) COMMENT '标签编码'"
  )
  private String tagCode;
}
