package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author hupan
 * @date 2023/6/29 11:17
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MemberInviteRecord", description = "会员邀请记录表")
@Entity
@TableName("mms_member_invite_record")
@Table(name = "mms_member_invite_record")
@org.hibernate.annotations.Table(appliesTo = "mms_member_invite_record", comment = "会员邀请记录表")
public class MemberInviteRecord extends TenantFlagOpEntity {

  @ApiModelProperty("邀请人姓名")
  @Column(name = "inviter_name",length = 100, columnDefinition = "VARCHAR(100) COMMENT '邀请人姓名'")
  private String inviterName;

  @ApiModelProperty("邀请人手机号")
  @Column(name="inviter_phone", length = 20, columnDefinition = "VARCHAR(20) COMMENT '邀请人手机号'")
  private String inviterPhone;

  @ApiModelProperty("邀请时间")
  @TableField(value = "invite_time")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "invite_time", length = -1, columnDefinition = "datetime COMMENT '邀请时间'")
  private Date inviteTime;

  @ApiModelProperty("受邀人姓名")
  @Column(name = "invitee_name",length = 100, columnDefinition = "VARCHAR(100) COMMENT '受邀人姓名'")
  private String inviteeName;

  @ApiModelProperty("受邀人手机号")
  @Column(name="invitee_phone", length = 20, columnDefinition = "VARCHAR(20) COMMENT '受邀人手机号'")
  private String inviteePhone;

}
