package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 消息弹窗管理
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/15 13:54
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MessageManage", description = "消息弹窗管理")
@Entity
@TableName("mms_message_manage")
@Table(
        name = "mms_message_manage")
@org.hibernate.annotations.Table(appliesTo = "mms_message_manage", comment = "消息弹窗管理")
public class MessageManage extends TenantFlagOpEntity {


    @ApiModelProperty("消息管理编码")
    @Column(name = "code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '消息管理编码'")
    private String code;

    @ApiModelProperty("标题")
    @Column(name = "title",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '标题'")
    private String title;

    @ApiModelProperty("内容")
    @Column(name = "content",nullable = false, length = 500, columnDefinition = "VARCHAR(64) COMMENT '内容'")
    private String content;

    @ApiModelProperty("触发类型")
    @Column(name = "trigger_type",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '触发类型'")
    private String triggerType;

    @ApiModelProperty("触发类型名称")
    @Column(name = "trigger_type_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '触发类型名称'")
    private String triggerTypeName;

    @ApiModelProperty("触发条件")
    @Column(name = "trigger_condition",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '触发条件'")
    private String triggerCondition;

    @ApiModelProperty("触发条件名称")
    @Column(name = "trigger_condition_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '触发条件名称'")
    private String triggerConditionName;

    @ApiModelProperty("节日编码")
    @Column(name = "holiday_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '节日编码'")
    private String holidayCode;

    @ApiModelProperty("节日名称")
    @Column(name = "holiday_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '节日名称'")
    private String holidayName;

    @ApiModelProperty("权重")
    @Column(name = "trigger_weight",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '权重'")
    private String triggerWeight;

    @ApiModelProperty("消息通知")
    @Column(name = "message_notify",nullable = false, columnDefinition = "int(1) COMMENT '消息通知'")
    private Boolean messageNotify = Boolean.FALSE;

    @ApiModelProperty("开屏弹窗通知")
    @Column(name = "popup_notify",nullable = false, columnDefinition = "int(1) COMMENT '开屏弹窗通知'")
    private Boolean popupNotify = Boolean.FALSE;
}
