package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 消息通知
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/15 14:13
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MessageNotify", description = "消息通知")
@Entity
@TableName("mms_message_notify")
@Table(
        name = "mms_message_notify")
@org.hibernate.annotations.Table(appliesTo = "mms_message_notify", comment = "消息通知")
public class MessageNotify extends TenantFlagOpEntity {

    @ApiModelProperty("消息管理编码")
    @Column(name = "message_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '消息管理编码'")
    private String messageCode;

    @ApiModelProperty("标题")
    @Column(name = "title",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '标题'")
    private String title;

    @ApiModelProperty("内容")
    @Column(name = "content",nullable = false, length = 500, columnDefinition = "VARCHAR(64) COMMENT '内容'")
    private String content;

    @ApiModelProperty("会员编码")
    @Column(name = "member_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '会员编码'")
    private String memberCode;

    @ApiModelProperty("发送标记,'0'表示已经发送过,'1'表示还没发送过")
    @Column(name = "send_flag", length = 64, columnDefinition = "VARCHAR(64) COMMENT '发送标记'")
    private String sendFlag;
}
