package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * 弹窗通知
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/15 14:14
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "PopupNotify", description = "弹窗通知")
@Entity
@TableName("mms_popup_notify")
@Table(
        name = "mms_popup_notify")
@org.hibernate.annotations.Table(appliesTo = "mms_popup_notify", comment = "弹窗通知")
public class PopupNotify extends TenantFlagOpEntity {

    @ApiModelProperty("消息管理编码")
    @Column(name = "message_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '消息管理编码'")
    private String messageCode;

    @ApiModelProperty("频次")
    @Column(name = "frequency",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '频次'")
    private String frequency;

    @ApiModelProperty("频次名称")
    @Column(name = "frequency_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '频次'")
    private String frequencyName;

    @ApiModelProperty("开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "start_date",nullable = false, length = 64, columnDefinition = "datetime COMMENT '开始时间'")
    private Date startDate;

    @ApiModelProperty("结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "end_date", nullable = false,length = 64, columnDefinition = "datetime COMMENT '结束时间'")
    private Date endDate;

    @ApiModelProperty("跳转")
    @Column(name = "skip_type",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '应用区域'")
    private String skipType;

    @ApiModelProperty("跳转")
    @Column(name = "skip_type_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '应用区域'")
    private String skipTypeName;

    @ApiModelProperty("跳转url")
    @Column(name = "skip_url",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '跳转url'")
    private String skipUrl;

    @ApiModelProperty("小程序id")
    @Column(name = "app_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '小程序id'")
    private String appId;

    /** 文件名 */
    @Column(name = "file_id", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 文件id '")
    @ApiModelProperty("文件id")
    private String fileId;

    /** 文件名 */
    @Column(name = "file_name", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 文件名 '")
    @ApiModelProperty("文件名")
    private String fileName;





}
