package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 奖品
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/19 13:55
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "PrizeEntity", description = "奖品")
@Entity
@TableName("mms_prize")
@Table(
        name = "mms_prize")
@org.hibernate.annotations.Table(appliesTo = "mms_prize", comment = "奖品")
public class PrizeEntity extends TenantFlagOpEntity {

    @ApiModelProperty("奖品编码")
    @Column(name = "code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '奖品编码'")
    private String code;

    @ApiModelProperty("奖品名称")
    @Column(name = "prize_name",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '奖品名称'")
    private String prizeName;

    @ApiModelProperty("奖品类型编码")
    @Column(name = "prize_type",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '奖品类型编码'")
    private String prizeType;

    @ApiModelProperty("奖品类型名称")
    @Column(name = "prize_type_name",length = 64, columnDefinition = "VARCHAR(64) COMMENT '奖品类型名称'")
    private String prizeTypeName;

    @ApiModelProperty("单价")
    @Column(name = "unit_price", columnDefinition = "decimal(10,2) COMMENT '单价'")
    private BigDecimal unitPrice;

    @ApiModelProperty("单位编码")
    @Column(name = "unit_code", columnDefinition = "VARCHAR(64) COMMENT '单位编码'")
    private String  unitCode;

    @ApiModelProperty("单位名称")
    @Column(name = "unit_name", columnDefinition = "VARCHAR(64) COMMENT '单位名称'")
    private String unitName;

    @ApiModelProperty("是否有库存")
    @Column(name = "inventory", columnDefinition = "VARCHAR(64) COMMENT '是否有库存'")
    private String inventory;

    @ApiModelProperty("库存数量")
    @Column(name = "inventory_num", columnDefinition = "decimal(10,0) COMMENT '库存数量'")
    private BigDecimal inventoryNum;

    @ApiModelProperty("领取有效期")
    @Column(name = "receive_time_limit", columnDefinition = "int(10) COMMENT '领取有效期'")
    private Integer receiveTimeLimit;

    @ApiModelProperty("虚拟有效期")
    @Column(name = "virtual_time_limit", columnDefinition = "int(10) COMMENT '虚拟有效期'")
    private Integer virtualTimeLimit;

    @Column(name = "file_id",  columnDefinition = "VARCHAR(255) COMMENT ' 文件id '")
    @ApiModelProperty("文件id")
    private String fileId;

    @Column(name = "file_name", columnDefinition = "VARCHAR(255) COMMENT ' 文件名 '")
    @ApiModelProperty("文件名")
    private String fileName;

    @Column(name = "product_des", columnDefinition = "VARCHAR(500) COMMENT ' 商品详情 '")
    @ApiModelProperty("商品详情")
    private String productDes;

    @ApiModelProperty("总数量")
    @Column(name = "total_num", nullable = false, columnDefinition = "decimal(10,0) COMMENT '总数量'")
    private BigDecimal totalNum = BigDecimal.ZERO;

    @ApiModelProperty("中奖数量")
    @Column(name = "put_num_hit",nullable = false, columnDefinition = "decimal(10,0) COMMENT '中奖数量'")
    private BigDecimal putNumHit = BigDecimal.ZERO;

    @ApiModelProperty("中奖已过期")
    @Column(name = "expired", nullable = false, columnDefinition = "decimal(10,0) COMMENT '中奖已过期'")
    private BigDecimal expired = BigDecimal.ZERO;

    @ApiModelProperty("领取已过期")
    @Column(name = "expired_claimed", nullable = false, columnDefinition = "decimal(10,0) COMMENT '领取已过期'")
    private BigDecimal expiredClaimed = BigDecimal.ZERO;

}
