package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 积分商城 商品信息
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/13 15:23
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "Product", description = "商品信息")
@Entity
@TableName("mms_product")
@Table(
        name = "mms_product")
@org.hibernate.annotations.Table(appliesTo = "mms_product", comment = "商品信息")
public class Product extends TenantFlagOpEntity {

    @ApiModelProperty("上架编码")
    @Column(name = "code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '上架编码'")
    private String code;

    @ApiModelProperty("上架名称")
    @Column(name = "name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '上架名称'")
    private String name;

    @ApiModelProperty("来源")
    @Column(name = "source", length = 64, columnDefinition = "VARCHAR(64) COMMENT '来源'")
    private String source;

    @ApiModelProperty("上下架状态")
    @Column(name = "status", length = 64, columnDefinition = "VARCHAR(64) COMMENT '上下架状态'")
    private String status;

    @ApiModelProperty("商品编码")
    @Column(name = "product_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '商品编码'")
    private String productCode;

    @ApiModelProperty("商品名称")
    @Column(name = "product_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '商品名称'")
    private String productName;

    @ApiModelProperty("商品类型(实物，虚拟)")
    @Column(name = "product_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '商品类型(实物，虚拟)'")
    private String productType;

    @ApiModelProperty("计量单位")
    @Column(name = "unit_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '计量单位'")
    private String unitCode;

    @ApiModelProperty("计量单位名称")
    @Column(name = "unit_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '计量单位名称'")
    private String unitName;

    @ApiModelProperty("商品分类编码")
    @Column(name = "product_category_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '商品分类编码'")
    private String productCategoryCode;

    @ApiModelProperty("商品分类名称")
    @Column(name = "product_category_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '商品分类名称'")
    private String productCategoryName;

    @ApiModelProperty("商品详情")
    @Column(name = "product_desc", length = 0, columnDefinition = "text COMMENT '商品详情'")
    private String productDesc;

}
