package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 商品分类
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/14 16:18
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProductCategory", description = "商品分类信息")
@Entity
@TableName("mms_product_category")
@Table(
        name = "mms_product_category")
@org.hibernate.annotations.Table(appliesTo = "mms_product_category", comment = "商品分类信息")
public class ProductCategory extends TenantFlagOpEntity {


    @Column(name = "category_code", nullable = false,columnDefinition = "VARCHAR(64) COMMENT '分类编码'")
    @ApiModelProperty("分类编码")
    private String categoryCode;

    @Column(name = "category_name", nullable = false,columnDefinition = "VARCHAR(64) COMMENT '分类名称'")
    @ApiModelProperty("分类名称")
    private String categoryName;
    /**
     * 排序（按数字顺序排列）
     */
    @Column(name = "sort_index", nullable = false,columnDefinition = "INT(7) COMMENT '排序（按数字顺序排列）'")
    @ApiModelProperty("排序（按数字顺序排列）")
    private Integer sortIndex;
}
