package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * mms_product_exchange_rule 商品兑换规则
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/13 15:48
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProductExchangeRule", description = "商品兑换规则")
@Entity
@TableName("mms_product_exchange_rule")
@Table(
        name = "mms_product_exchange_rule")
@org.hibernate.annotations.Table(appliesTo = "mms_product_exchange_rule", comment = "商品兑换规则")
public class ProductExchangeRule extends TenantFlagOpEntity {

    @ApiModelProperty("上架编码")
    @Column(name = "shelf_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '上架编码'")
    private String ShelfCode;

    @ApiModelProperty("等级限制编码")
    @Column(name = "level_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '等级限制编码'")
    private String levelCode;

    @ApiModelProperty("等级限制名称")
    @Column(name = "level_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '等级限制名称'")
    private String levelName;

    @ApiModelProperty("兑换周期")
    @Column(name = "exchange_period", length = 64, columnDefinition = "VARCHAR(64) COMMENT '兑换周期'")
    private String exchangePeriod;

    @ApiModelProperty("兑换周期名称")
    @Column(name = "exchange_period_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '兑换周期名称'")
    private String exchangePeriodName;

    @ApiModelProperty("可兑数量")
    @Column(name = "quantity", columnDefinition = "decimal(10,0) COMMENT '可兑数量'")
    private BigDecimal quantity;

    @ApiModelProperty("积分价格")
    @Column(name = "integral_price", columnDefinition = "decimal(10,2) COMMENT '积分价格'")
    private BigDecimal integralPrice;

    @ApiModelProperty("投放数量")
    @Column(name = "put_in_num", columnDefinition = "decimal(10,0) COMMENT '投放数量'")
    private BigDecimal putInNum;

    @ApiModelProperty("库存数量")
    @Column(name = "inventory_quantity", columnDefinition = "decimal(10,0) COMMENT '库存数量'")
    private BigDecimal inventoryQuantity;

    @ApiModelProperty("上架时间）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "up_date", length = 64, columnDefinition = "datetime COMMENT '上架时间'")
    private Date upDate;

    @ApiModelProperty("下架时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "down_date", length = 64, columnDefinition = "datetime COMMENT '下架时间'")
    private Date downDate;

    @ApiModelProperty("使用有效期")
    @Column(name = "validate_use", columnDefinition = "int(10) COMMENT '使用有效期'")
    private Integer validateUse;
}
