package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 商品轮播图
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/13 16:07
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProductFile", description = "商品轮播图")
@Entity
@TableName("mms_product_file")
@Table(
        name = "mms_product_file")
@org.hibernate.annotations.Table(appliesTo = "mms_product_file", comment = "商品轮播图")
public class ProductFile extends TenantFlagOpEntity {

    @ApiModelProperty("上架编码")
    @Column(name = "shelf_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '上架编码'")
    private String ShelfCode;

    /** 相对路径 */
    @Column(name = "relative_path", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 相对路径 '")

    @ApiModelProperty("相对路径")
    private String relativePath;

    /** 文件名 */
    @Column(name = "file_id", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 文件id '")
    @ApiModelProperty("文件id")
    private String fileId;

    /** 文件名 */
    @Column(name = "file_name", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 文件名 '")
    @ApiModelProperty("文件名")
    private String fileName;

    /** 图片类型 */
    @Column(name = "type", nullable = true, columnDefinition = "VARCHAR(255) COMMENT ' 图片类型 '")
    @ApiModelProperty("图片类型")
    private String type;

    /** 是主图 */
    @Column(name = "main_image", nullable = false, columnDefinition = "tinyint(1) COMMENT ' 是主图 '")
    @ApiModelProperty("是主图")
    @JsonProperty(value = "mainImage")
    private Boolean mainImage;

    /**
     * 排序（按数字顺序排列）
     */
    @Column(name = "sort_index", nullable = false,columnDefinition = "INT(7) COMMENT '排序（按数字顺序排列）'")
    @ApiModelProperty("排序（按数字顺序排列）")
    private Integer sortIndex;
}
