package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/20 11:42
 * @description 问卷管理
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "Questionnaire", description = "问卷管理")
@Entity
@TableName("mms_questionnaire")
@Table(name = "mms_questionnaire")
@org.hibernate.annotations.Table(appliesTo = "mms_questionnaire", comment = "问卷管理")
public class Questionnaire extends TenantFlagOpEntity {
  @ApiModelProperty("问卷编码")
  @Column(name = "code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '问卷编码'")
  private String code;

  @ApiModelProperty("问卷标题")
  @Column(name = "title", length = 30, columnDefinition = "VARCHAR(64) COMMENT '问卷标题'")
  private String title;

  @ApiModelProperty("参与问卷可获得积分")
  @Column(name = "obtain_points", length = 10, columnDefinition = "decimal(8,2) COMMENT '参与可获得积分'")
  private BigDecimal obtainPoints;

  @ApiModelProperty("开始时间")
  @Column(name = "start_time", length = 20,columnDefinition = "datetime COMMENT '开始时间'")
  private Date startTime;

  @ApiModelProperty("结束时间")
  @Column(name = "end_time", length = 20, columnDefinition = "datetime COMMENT '结束时间'")
  private Date endTime;

  @ApiModelProperty("背景图片")
  @Column(name = "background_pic", length = 100, columnDefinition = "VARCHAR(100) COMMENT '背景图片'")
  private String backgroundPic;

  @ApiModelProperty("状态,数据字典:mms_questionnaire_status,枚举:QuestionnaireStatusEnum")
  @Column(name = "pub_status", length = 64, columnDefinition = "VARCHAR(64) COMMENT '状态'")
  private String pubStatus;

  @ApiModelProperty("问卷说明")
  @Column(name = "description", length = 255 ,columnDefinition = "VARCHAR(255) COMMENT '问卷说明'")
  private String description;

  @ApiModelProperty("完成问卷提示")
  @Column(name = "complete_tips", length = 255, columnDefinition = "VARCHAR(255) COMMENT '完成问卷提示'")
  private String completeTips;
}
