package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/20 14:11
 * @description 问卷题目
 */
@ApiModel(value = "QuestionnaireQuestion", description = "问卷题目")
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mms_questionnaire_question")
@Table(name = "mms_questionnaire_question")
@org.hibernate.annotations.Table(appliesTo = "mms_questionnaire_question", comment = "问卷题目")
public class QuestionnaireQuestion extends TenantFlagOpEntity {
  @ApiModelProperty("题目编码")
  @Column(name = "code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '题目编码'")
  private String code;

  @ApiModelProperty("问卷编码")
  @Column(name = "questionnaire_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '问卷编码'")
  private String questionnaireCode;

  @ApiModelProperty("组件字段")
  @Column(name = "field", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '组件字段'")
  private String field;

  @ApiModelProperty("提示语")
  @Column(name = "placeholder", length = 64, columnDefinition = "VARCHAR(64) COMMENT '提示语'")
  private String placeholder;

  @ApiModelProperty("组件类型")
  @TableField(value = "type")
  @Column(name = "type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '组件类型'")
  private String type;

  @ApiModelProperty("是否必填")
  @Column(name = "required", length = 1, columnDefinition = "tinyint(1) COMMENT '是否必填'")
  private Boolean required;

  @ApiModelProperty("默认值")
  @Column(name = "default_value", length = 100 ,columnDefinition = "VARCHAR(100) COMMENT '默认值'")
  private String defaultValue;

  @ApiModelProperty("排序(按数字顺序排序)")
  @Column(name = "sort_index", length = 7, columnDefinition = "INT(7) COMMENT '排序(按数字顺序排序)'")
  private Integer sortIndex;

  @ApiModelProperty("题目标题")
  @Column(name = "title", length = 64, columnDefinition = "VARCHAR(64) COMMENT '题目标题'")
  private String title;

  @ApiModelProperty("多选/单选的json值")
  @Column(name = "config_json_value", length = 500, columnDefinition = "VARCHAR(500) COMMENT '多选/单选的json值'")
  private String configJsonValue;
}
