package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.models.auth.In;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 大转盘活动基础配置
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/19 13:36
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RaffleBaseConfig", description = "大转盘活动基础配置")
@Entity
@TableName("mms_raffle_base_config")
@Table(
        name = "mms_raffle_base_config")
@org.hibernate.annotations.Table(appliesTo = "mms_raffle_base_config", comment = "大转盘活动基础配置")
public class RaffleBaseConfig extends TenantFlagOpEntity {


    @ApiModelProperty("大转盘活动编码")
    @Column(name = "raffle_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '大转盘活动编码'")
    private String raffleCode;

    @ApiModelProperty("会员等级编码")
    @Column(name = "member_level_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '会员等级编码'")
    private String memberLevelCode;

    @ApiModelProperty("会员等级名称")
    @Column(name = "member_level_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '会员等级名称'")
    private String memberLevelName;

    @ApiModelProperty("会员等级json")
    @Column(name = "member_level_json", length = 64, columnDefinition = "VARCHAR(256) COMMENT '会员等级json'")
    private String memberLevelJson;

    @ApiModelProperty("一段每天抽奖次数")
    @Column(name = "one_raffle_num", nullable = false, columnDefinition = "int(10) COMMENT '一段每天抽奖次数'")
    private Integer oneRaffleNum;

    @ApiModelProperty("一段每次消耗积分")
    @Column(name = "one_raffle_use_integral", nullable = false, columnDefinition = "int(10) COMMENT '一段每次消耗积分'")
    private Integer oneRaffleUseIntegral;

    @ApiModelProperty("二段每天抽奖次数")
    @Column(name = "two_raffle_num", columnDefinition = "int(10) COMMENT '二段每天抽奖次数'")
    private Integer twoRaffleNum;

    @ApiModelProperty("二段每次消耗积分")
    @Column(name = "two_raffle_use_integral", columnDefinition = "int(10) COMMENT '二段每次消耗积分'")
    private Integer twoRaffleUseIntegral;

}
