package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * 大转盘管理
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/19 10:42
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RaffleManage", description = "大转盘管理")
@Entity
@TableName("mms_raffle_manage")
@Table(
        name = "mms_raffle_manage")
@org.hibernate.annotations.Table(appliesTo = "mms_raffle_manage", comment = "大转盘管理")
public class RaffleManage extends TenantFlagOpEntity {


    @ApiModelProperty("编码")
    @Column(name = "code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '编码'")
    private String code;

    @ApiModelProperty("活动名称")
    @Column(name = "activity_name",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动名称'")
    private String activityName;

    @ApiModelProperty("背景图片id")
    @Column(name = "background_file_id",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '背景图片id'")
    private String backgroundFileId;

    @ApiModelProperty("背景图片名称")
    @Column(name = "background_file_name",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '背景图片名称'")
    private String backgroundFileName;

    @ApiModelProperty("转盘图片id")
    @Column(name = "file_id",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '转盘图片id'")
    private String fileId;

    @ApiModelProperty("转盘图片名称")
    @Column(name = "file_name",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '转盘图片名称'")
    private String fileName;


    @ApiModelProperty("开始按钮图片id")
    @Column(name = "start_button_file_id",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '开始按钮图片id'")
    private String startButtonFileId;

    @ApiModelProperty("开始按钮图片名称")
    @Column(name = "start_button_file_name",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '开始按钮图片名称'")
    private String startButtonFileName;

    @ApiModelProperty("分割线图片id")
    @Column(name = "cutting_line_file_id",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '分割线图片id'")
    private String cuttingLineFileId;

    @ApiModelProperty("分割线图片名称")
    @Column(name = "cutting_line_file_name",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '分割线图片名称'")
    private String cuttingLineFileName;

    @ApiModelProperty("活动开始时间（开始）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "start_date", nullable = false, columnDefinition = "datetime COMMENT '报名时间（开始）'")
    private Date startDate;

    @ApiModelProperty("活动结束时间（结束）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "end_date", nullable = false, columnDefinition = "datetime COMMENT '报名时间（结束）'")
    private Date endDate;

    @ApiModelProperty("规则文案")
    @Column(name = "rule_des", columnDefinition = "text COMMENT '规则文案'")
    private String ruleDes;





}
