package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 大转盘奖品信息详情
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/19 15:21
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RafflePrizeDetails", description = "大转盘奖品信息详情")
@Entity
@TableName("mms_raffle_prize_details")
@Table(
        name = "mms_raffle_prize_details")
@org.hibernate.annotations.Table(appliesTo = "mms_raffle_prize_details", comment = "大转盘奖品信息详情")
public class RafflePrizeDetails extends TenantFlagOpEntity {


    @ApiModelProperty("大转盘奖项编码")
    @Column(name = "code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '奖品配置编码'")
    private String code;

    @ApiModelProperty("大转盘奖品配置编码")
    @Column(name = "raffle_prize_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '奖品配置编码'")
    private String rafflePrizeCode;

    @ApiModelProperty("大转盘编码")
    @Column(name = "raffle_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '奖品配置编码'")
    private String raffleCode;

    @ApiModelProperty("奖品等级编码")
    @Column(name = "prize_level",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '奖品等级编码'")
    private String prizeLevel;

    @ApiModelProperty("奖品等级名称")
    @Column(name = "prize_level_name",length = 64, columnDefinition = "VARCHAR(64) COMMENT '奖品等级名称'")
    private String prizeLevelName;

    @ApiModelProperty("奖品编码")
    @Column(name = "prize_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '奖品编码'")
    private String prizeCode;

    @ApiModelProperty("奖品名称")
    @Column(name = "prize_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '奖品名称'")
    private String prizeName;

    @ApiModelProperty("展示名称")
    @Column(name = "show_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '展示名称'")
    private String showName;

    @ApiModelProperty("数量")
    @Column(name = "quantity", columnDefinition = "decimal(10,0) COMMENT '数量'")
    private BigDecimal quantity;

    @ApiModelProperty("投放份数")
    @Column(name = "put_copies", nullable = false,columnDefinition = "decimal(10,0) COMMENT '投放份数'")
    private BigDecimal putCopies;

    @ApiModelProperty("概率")
    @Column(name = "prize_prob",nullable = false, columnDefinition = "decimal(10,2) COMMENT '概率'")
    private BigDecimal prizeProb;

    @ApiModelProperty("可投放数量")
    @Column(name = "can_put_num", columnDefinition = "decimal(10,0) COMMENT '可投放数量'")
    private BigDecimal canPutNum;

    @ApiModelProperty("投放数量")
    @Column(name = "put_num", nullable = false, columnDefinition = "decimal(10,0) COMMENT '投放数量'")
    private BigDecimal putNum;

    @ApiModelProperty("投放库存份数")
    @Column(name = "put_inventory_copies",nullable = false, columnDefinition = "decimal(10,0) COMMENT '投放库存份数'")
    private BigDecimal putInventoryCopies;

    @ApiModelProperty("投放库存数量")
    @Column(name = "put_inventory_num",nullable = false, columnDefinition = "decimal(10,0) COMMENT '投放库存数量'")
    private BigDecimal putInventoryNum;

    @ApiModelProperty("使用有效期(天)")
    @Column(name = "use_validate", columnDefinition = "int(10) COMMENT '使用有效期'")
    private Integer useValidate;

    @ApiModelProperty("领取有效期(天)")
    @Column(name = "claim_validate", columnDefinition = "int(10) COMMENT '领取有效期'")
    private Integer claimValidate;

    @ApiModelProperty("库存数量")
    @Column(name = "inventory_num", columnDefinition = "decimal(10,0) COMMENT '库存数量'")
    private BigDecimal inventoryNum;

    @ApiModelProperty("是否为选择的无库存奖励(奖品发完后选择为无库存奖品)")
    @Column(name = "prize_flag", columnDefinition = "tinyint(1) COMMENT '是否为选择的无库存奖励(奖品发完后选择为无库存奖品)'")
    private Boolean prizeFlag;

}
