package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 大转盘活动奖品信息
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/19 13:37
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RafflePrizeEntity", description = "大转盘活动奖品信息")
@Entity
@TableName("mms_raffle_prize")
@Table(
        name = "mms_raffle_prize")
@org.hibernate.annotations.Table(appliesTo = "mms_raffle_prize", comment = "大转盘活动奖品信息")
public class RafflePrizeEntity extends TenantFlagOpEntity {


    @ApiModelProperty("大转盘活动编码")
    @Column(name = "raffle_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '大转盘活动编码'")
    private String raffleCode;

    @ApiModelProperty("编码")
    @Column(name = "code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '大转盘活动编码'")
    private String code;

    @ApiModelProperty("会员等级编码")
    @Column(name = "member_level_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '会员等级编码'")
    private String memberLevelCode;

    @ApiModelProperty("会员等级名称")
    @Column(name = "member_level_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '会员等级名称'")
    private String memberLevelName;

    @ApiModelProperty("会员等级json")
    @Column(name = "member_level_json", length = 64, columnDefinition = "VARCHAR(256) COMMENT '会员等级json'")
    private String memberLevelJson;

    @ApiModelProperty("奖品发完选择,数据字典:mms_prize_over_select 枚举:PrizeOverSelectEnum")
    @Column(name = "prize_over_select", length = 64, columnDefinition = "VARCHAR(64) COMMENT '奖品发完选择'")
    private String prizeOverSelect;


    @ApiModelProperty("抽奖奖品池")
    @Column(name = "prize_pool", columnDefinition = " text COMMENT '抽奖奖品池'")
    private String prizePool;


}
