package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 大转盘中奖记录
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/20 13:39
 **/

@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RafflePrizeRecord", description = "大转盘中奖记录")
@Entity
@TableName("mms_raffle_prize_record")
@Table(
        name = "mms_raffle_prize_record")
@org.hibernate.annotations.Table(appliesTo = "mms_raffle_prize_record", comment = "大转盘中奖记录")
public class RafflePrizeRecord extends TenantFlagOpEntity {

    @ApiModelProperty("中奖记录编码")
    @Column(name = "code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '中奖记录编码'")
    private String code;

    @ApiModelProperty("中奖人编码")
    @Column(name = "member_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '中奖人编码'")
    private String memberCode;

    @ApiModelProperty("奖项编码")
    @Column(name = "raffle_prize_detail_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '奖项编码'")
    private String rafflePrizeDetailCode;

    @Column(name = "raffle_prize_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '奖品信息配置编码'")
    private String rafflePrizeCode;

    @ApiModelProperty("大转盘活动编码")
    @Column(name = "activity_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '大转盘活动编码'")
    private String activityCode;

    @ApiModelProperty("活动名称")
    @Column(name = "activity_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动名称'")
    private String activityName;

    @ApiModelProperty("姓名")
    @Column(name = "name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '姓名'")
    private String name;

    @ApiModelProperty("手机号")
    @Column(name = "phone",length = 64, columnDefinition = "VARCHAR(64) COMMENT '手机号'")
    private String phone;

    @ApiModelProperty("会员等级编码")
    @Column(name = "member_level_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '会员等级编码'")
    private String memberLevelCode;

    @ApiModelProperty("会员等级名称")
    @Column(name = "member_level_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '会员等级名称'")
    private String memberLevelName;

    @ApiModelProperty("奖品等级编码")
    @Column(name = "prize_level",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '奖品等级编码'")
    private String prizeLevel;

    @ApiModelProperty("奖品等级名称")
    @Column(name = "prize_level_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '奖品等级名称'")
    private String prizeLevelName;

    @ApiModelProperty("奖品编码")
    @Column(name = "prize_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '奖品编码'")
    private String prizeCode;

    @ApiModelProperty("奖品类型编码")
    @Column(name = "prize_type",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '奖品类型编码'")
    private String prizeType;

    @ApiModelProperty("数量")
    @Column(name = "quantity", columnDefinition = "decimal(10,0) COMMENT '数量'")
    private BigDecimal quantity;

    @ApiModelProperty("领取状态code")
    @Column(name = "claim_status",length = 64, columnDefinition = "VARCHAR(64) COMMENT '领取状态code'")
    private String claimStatus;

    @ApiModelProperty("领取时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "claim_time",  columnDefinition = "datetime COMMENT '领取时间'")
    private Date claimTime;

    @ApiModelProperty("使用状态")
    @Column(name = "employ_status",length = 64, columnDefinition = "VARCHAR(64) COMMENT '使用状态'")
    private String employStatus;

    @ApiModelProperty("使用时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "employ_time", columnDefinition = "datetime COMMENT '使用时间'")
    private Date employTime;

    @ApiModelProperty("地址")
    @Column(name = "address",length = 64, columnDefinition = "VARCHAR(64) COMMENT '领取状态code'")
    private String address;

}
