package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.WorkflowFlagOpEntity;
import com.biz.crm.member.business.member.sdk.vo.ProWorkflowFlagOpEntity;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 实物订单
 * @author zouhs
 * @date 2023/6/13
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RealOrder", description = "实物订单")
@Entity
@TableName("mms_real_order")
@Table(
    name = "mms_real_order",
    indexes = {
        @Index(name = "mms_real_order_index1", columnList = "order_code",unique = true),
        @Index(name = "mms_real_order_index2", columnList = "user_code"),
    })
@org.hibernate.annotations.Table(appliesTo = "mms_real_order", comment = "实物订单")
public class RealOrder extends ProWorkflowFlagOpEntity {

    @ApiModelProperty("订单号")
    @Column(name = "order_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '订单号'")
    private String orderCode;

    @ApiModelProperty("订单状态,数据字典:mms_real_order_status,枚举:RealOrderStatusEnum")
    @Column(name = "order_status", length = 20, columnDefinition = "VARCHAR(20) COMMENT '订单状态'")
    private String orderStatus;

    @ApiModelProperty("订单类型,数据字典:mms_real_order_type,枚举:RealOrderTypeEnum")
    @Column(name = "order_type", length = 20, columnDefinition = "VARCHAR(20) COMMENT '订单类型'")
    private String orderType;

    @ApiModelProperty("订单来源,数据字典:mms_order_source,枚举:OrderSourceEnum")
    @Column(name = "order_source", length = 20, columnDefinition = "VARCHAR(20) COMMENT '订单来源'")
    private String orderSource;

    @ApiModelProperty("兑换合计支付积分")
    @Column(name = "integral_num", length = 20, columnDefinition = "VARCHAR(20) COMMENT '兑换合计支付积分'")
    private Integer integralNum;

    @ApiModelProperty("关联客户编码")
    @Column(name = "user_code", length = 60, columnDefinition = "VARCHAR(60) COMMENT '关联客户编码'")
    private String userCode;

    @ApiModelProperty("关联客户名称")
    @Column(name = "user_name", length = 60, columnDefinition = "VARCHAR(60) COMMENT '关联客户名称'")
    private String userName;

    @ApiModelProperty("下单时间")
    @TableField(value = "order_time")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "order_time", length = -1, columnDefinition = "date COMMENT '下单时间'")
    private Date orderTime;

    @ApiModelProperty("下单人姓名")
    @Column(name = "order_name", length = 45, columnDefinition = "VARCHAR(45) COMMENT '下单人姓名'")
    private String orderName;

    @ApiModelProperty("下单人手机号")
    @Column(name = "order_phone", length = 20, columnDefinition = "VARCHAR(20) COMMENT '下单人手机号'")
    private String orderPhone;

    @ApiModelProperty("商品缩略图")
    @Column(name = "product_img", length = 255, columnDefinition = "VARCHAR(255) COMMENT '商品缩略图'")
    private String productImg;

    @ApiModelProperty("商品名称")
    @Column(name = "product_name", length = 60, columnDefinition = "VARCHAR(60) COMMENT '商品名称'")
    private String productName;

    @ApiModelProperty("商品价格(单价)")
    @Column(name = "integral_price", columnDefinition = "decimal(10,2) COMMENT '商品价格(单价)'")
    private BigDecimal integralPrice;

    @ApiModelProperty("商品编码")
    @Column(name = "product_code", length = 45, columnDefinition = "VARCHAR(45) COMMENT '商品编码'")
    private String productCode;

    @ApiModelProperty("商品数量")
    @Column(name = "product_num", length = 11, columnDefinition = "int(11) COMMENT '商品数量'")
    private Integer productNum;

    @ApiModelProperty("关联组织编码")
    @Column(name = "org_code", length = 45, columnDefinition = "VARCHAR(45) COMMENT '关联组织编码'")
    private String orgCode;

    @ApiModelProperty("关联组织名称")
    @Column(name = "org_name", length = 45, columnDefinition = "VARCHAR(45) COMMENT '关联组织名称'")
    private String orgName;

    @ApiModelProperty("核销人编码")
    @Column(name = "write_off_code", length = 40, columnDefinition = "VARCHAR(40) COMMENT '核销人编码'")
    private String writeOffCode;

    @ApiModelProperty("核销人")
    @Column(name = "write_off_name", length = 60, columnDefinition = "VARCHAR(60) COMMENT '核销人'")
    private String writeOffName;

    @ApiModelProperty("核销时间")
    @TableField(value = "write_off_time")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "write_off_time", length = -1, columnDefinition = "date COMMENT '核销时间'")
    private Date writeOffTime;

    @ApiModelProperty("关联经销商编码")
    @Column(name = "relation_agent_code", length = 40, columnDefinition = "VARCHAR(40) COMMENT '关联经销商编码'")
    private String relationAgentCode;

    @ApiModelProperty("关联经销商")
    @Column(name = "relation_agent_name", length = 60, columnDefinition = "VARCHAR(60) COMMENT '关联经销商'")
    private String relationAgentName;

    @ApiModelProperty("快递单号")
    @Column(name = "express_num", length = 60, columnDefinition = "VARCHAR(60) COMMENT '快递单号'")
    private String expressNum;

    @ApiModelProperty("是否分发 Y-N")
    @Column(name = "flag_distribute", length = 5, columnDefinition = "VARCHAR(5) COMMENT '是否分发 Y-N'")
    private String flagDistribute;

    @ApiModelProperty("办事处负责人编码")
    @Column(name = "office_code", length = 45, columnDefinition = "VARCHAR(45) COMMENT '办事处负责人编码'")
    private String officeCode;

    @ApiModelProperty("办事处负责人")
    @Column(name = "office_name", length = 45, columnDefinition = "VARCHAR(45) COMMENT '办事处负责人'")
    private String officeName;

    @ApiModelProperty("办事处负责人手机号")
    @Column(name = "office_phone", length = 20, columnDefinition = "VARCHAR(20) COMMENT '办事处负责人手机号'")
    private String officePhone;

    @ApiModelProperty("业务员编码")
    @Column(name = "salesman_code", length = 45, columnDefinition = "VARCHAR(45) COMMENT '业务员编码'")
    private String salesmanCode;

    @ApiModelProperty("业务员")
    @Column(name = "salesman_name", length = 45, columnDefinition = "VARCHAR(45) COMMENT '业务员'")
    private String salesmanName;

    @ApiModelProperty("业务员手机号")
    @Column(name = "salesman_phone", length = 20, columnDefinition = "VARCHAR(20) COMMENT '业务员手机号'")
    private String salesmanPhone;

    @ApiModelProperty("签收时间")
    @TableField(value = "receipt_time")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "receipt_time", length = -1, columnDefinition = "date COMMENT '签收时间'")
    private Date receiptTime;

    @ApiModelProperty("收货人")
    @Column(name = "receipt_name", length = 45, columnDefinition = "VARCHAR(45) COMMENT '收货人'")
    private String receiptName;

    @ApiModelProperty("收货人手机号")
    @Column(name = "receipt_phone", length = 20, columnDefinition = "VARCHAR(20) COMMENT '收货人手机号'")
    private String receiptPhone;

    @ApiModelProperty("收货地址")
    @Column(name = "receipt_address", length = 255, columnDefinition = "VARCHAR(255) COMMENT '收货地址'")
    private String receiptAddress;

    @ApiModelProperty("结算状态,数据字典:mms_order_settle_status,枚举:OrderSettleStatusEnum")
    @Column(name = "settle_status", length = 60, columnDefinition = "VARCHAR(60) COMMENT '结算状态' default 'stay_settle'")
    private String settleStatus;

    @ApiModelProperty("关联中奖记录编码")
    @Column(name = "relation_code", length = 60, columnDefinition = "VARCHAR(60) COMMENT '关联中奖记录编码'")
    private String relationCode;

    /** 工作流参数 */
    @ApiModelProperty("工作流参数")
    @Transient
    @TableField(exist = false)
    private ProcessBusinessDto processBusiness;

}
