package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 用户抽奖使用次数
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/29 11:02
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RewardActivityUserCountEntity", description = "用户抽奖使用次数")
@Entity
@TableName("mms_reward_activity_user_count")
@Table(
        name = "mms_reward_activity_user_count")
@org.hibernate.annotations.Table(appliesTo = "mms_reward_activity_user_count", comment = "用户抽奖使用次数")
public class RewardActivityUserCountEntity extends TenantEntity {

    @ApiModelProperty(name = "member_code", value = "会员编码")
    @Column(name = "member_code", nullable = false, columnDefinition = "varchar(64) COMMENT '会员编码'")
    private String memberCode;

    @ApiModelProperty(name = "useTimes", value = "使用次数")
    @Column(name = "use_times", nullable = false, columnDefinition = "varchar(64) COMMENT '使用次数'")
    private Integer useTimes;
}
