package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 景区管理
 *
 * @author hupan
 * @date 2023/6/20 10:24
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ScenicAreaManagement", description = "景区管理")
@Entity
@TableName("mms_scenic_area_management")
@Table(name = "mms_scenic_area_management")
@org.hibernate.annotations.Table(appliesTo = "mms_scenic_area_management", comment = "景区管理")
public class ScenicAreaManagement extends TenantFlagOpEntity {

  @ApiModelProperty("VR景区编码")
  @Column(name = "code", length = 64, columnDefinition = "VARCHAR(64) COMMENT 'VR景区编码'")
  private String code;

  @ApiModelProperty("VR景区名称")
  @Column(name = "name", length = 64, columnDefinition = "VARCHAR(64) COMMENT 'VR景区名称'")
  private String name;

  @ApiModelProperty("浏览量")
  @Column(name = "view_number", length = 5, columnDefinition = "int(5) COMMENT '浏览量'")
  private Integer viewNumber;

  @ApiModelProperty("16进制背景颜色")
  @Column(name = "scenic_icon_background", length = 64, columnDefinition = "VARCHAR(64) COMMENT '16进制背景颜色'")
  private String scenicIconBackground;
}
