package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 景区/景点的图片/视频,管理
 * @author hupan
 * @date 2023/6/20 10:39
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ScenicAreaManagement", description = "景区/景点的图片/视频,管理")
@Entity
@TableName("mms_scenic_image_management")
@Table(name = "mms_scenic_image_management")
@org.hibernate.annotations.Table(appliesTo = "mms_scenic_image_management", comment = "景区/景点的图片/视频,管理")
public class ScenicImageManagement extends FileEntity {

  @ApiModelProperty("景区id")
  @Column(name = "scenic_area_id", length = 32, columnDefinition = "VARCHAR(32) COMMENT '景区ID'")
  private String scenicAreaId;

  @ApiModelProperty("权益类型,数据字典:mms_scenic_image_type,枚举:ScenicImageTypeEnum")
  @Column(name = "type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '图片/视频的类型'")
  private String type;

  @ApiModelProperty("图片/视频url")
  @Column(name = "url", length = 100, columnDefinition = "VARCHAR(100) COMMENT '图片/视频url'")
  private String url;
}
