package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 景点管理
 *
 * @author hupan
 * @date 2023/6/20 10:30
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ScenicSpotsManagement", description = "景点管理")
@Entity
@TableName("mms_scenic_spots_management")
@Table(name = "mms_scenic_spots_management")
@org.hibernate.annotations.Table(appliesTo = "mms_scenic_spots_management", comment = "景点管理")

public class ScenicSpotsManagement extends TenantFlagOpEntity {

  @ApiModelProperty("景区id")
  @Column(name = "scenic_area_id", length = 32, columnDefinition = "VARCHAR(32) COMMENT '景区ID'")
  private String scenicAreaId;

  @ApiModelProperty("景区名称")
  @Column(name = "scenic_area_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '景区名称'")
  private String scenicAreaName;

  @ApiModelProperty("景点编码")
  @Column(name = "code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '景点编码'")
  private String code;

  @ApiModelProperty("景点名称")
  @Column(name = "name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '景点名称'")
  private String name;

  @ApiModelProperty("浏览量")
  @Column(name = "view_number", length = 5, columnDefinition = "int(5) COMMENT '浏览量'")
  private Integer viewNumber;

  @ApiModelProperty("解说音频")
  @Column(name = "explanation_audio_url", length = 100, columnDefinition = "VARCHAR(100) COMMENT '解说音频'")
  private String explanationAudioUrl;
}
