package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 签到规则
 * @author zouhs
 * @date 2023/6/15
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SignInRule", description = "签到规则")
@Entity
@TableName("mms_sign_in_rule")
@Table(
    name = "mms_sign_in_rule")
@org.hibernate.annotations.Table(appliesTo = "mms_sign_in_rule", comment = "签到规则")
public class SignInRule extends TenantFlagOpEntity {

  @ApiModelProperty("签到规则文本")
  @Column(name = "sign_desc", length = 0, columnDefinition = "text COMMENT '签到规则文本'")
  private String signDesc;

  @ApiModelProperty("每次可获得x积分")
  @Column(name = "every_integral", length = 11, columnDefinition = "int(11) COMMENT '每次可获得x积分'")
  private Integer everyIntegral;

  @ApiModelProperty("每年至多可获得x积分")
  @Column(name = "year_integral_limit", length = 11, columnDefinition = "int(11) COMMENT '每年至多可获得x积分'")
  private Integer yearIntegralLimit;

}
