package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 签到规则明细
 *
 * @author zouhs
 * @date 2023/6/15
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SignInRuleDetail", description = "签到规则明细")
@Entity
@TableName("mms_sign_in_rule_detail")
@Table(
    name = "mms_sign_in_rule_detail",
    indexes = {
        @Index(name = "mms_sign_in_rule_detail_index1", columnList = "sign_in_id")
    })
@org.hibernate.annotations.Table(appliesTo = "mms_sign_in_rule_detail", comment = "签到规则明细")
public class SignInRuleDetail extends TenantFlagOpEntity {

  @ApiModelProperty("签到规则ID")
  @Column(name = "sign_in_id", length = 32, columnDefinition = "VARCHAR(32) COMMENT '签到规则ID'")
  private String signInId;

  @ApiModelProperty("本月连续签到X天")
  @Column(name = "link_day_num", length = 11, columnDefinition = "int(11) COMMENT '本月连续签到X天'")
  private Integer linkDayNum;

  @ApiModelProperty("可额外获得x积分")
  @Column(name = "link_integral_num", length = 11, columnDefinition = "int(11) COMMENT '可额外获得x积分'")
  private Integer linkIntegralNum;

  @ApiModelProperty("图标")
  @Column(name = "icon_image", length = 64, columnDefinition = "VARCHAR(64) COMMENT '图标'")
  private String iconImage;

  @ApiModelProperty("描述")
  @Column(name = "sign_desc", length = 200, columnDefinition = "VARCHAR(200) COMMENT '描述'")
  private String signDesc;

  @ApiModelProperty("排序")
  @Column(name = "seq", length = 5, columnDefinition = "int(5) COMMENT '排序'")
  private Integer seq;

}
