package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 系统设置
 *
 * @author hupan
 * @date 2023/6/21 10:05
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SystemSettings", description = "系统设置")
@Entity
@TableName("mms_system_settings")
@Table(name = "mms_system_settings")
@org.hibernate.annotations.Table(appliesTo = "mms_system_settings", comment = "系统设置")
public class SystemSettings extends TenantFlagOpEntity {

  @ApiModelProperty("类型，枚举，枚举数据字典mms_system_settings_type，枚举类SystemSettingsTypeEnum")
  @Column(name = "`type`", length = 64, columnDefinition = "VARCHAR(64) COMMENT '类型'")
  private String type;

}
