package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @author hupan
 * @date 2023/6/21 10:47
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SystemSettingsDetail", description = "系统设置明细")
@Entity
@TableName("mms_system_settings_detail")
@Table(name = "mms_system_settings_detail")
@org.hibernate.annotations.Table(appliesTo = "mms_system_settings_detail", comment = "系统设置明细")
public class SystemSettingsDetail extends TenantFlagOpEntity {

  @ApiModelProperty("类型，枚举，枚举数据字典mms_system_settings_type，枚举类SystemSettingsTypeEnum")
  @Column(name = "`type`", length = 64, columnDefinition = "VARCHAR(64) COMMENT '类型'")
  private String type;

  @ApiModelProperty("属性名称")
  @Column(name = "`type_key`", length = 64, columnDefinition = "VARCHAR(64) COMMENT '属性名称'")
  private String typeKey;

  @ApiModelProperty("属性值，存储短数据")
  @Column(name = "type_value", length = 64, columnDefinition = "VARCHAR(64) COMMENT '属性值，存储短数据'")
  private String typeValue;

  @ApiModelProperty("属性值，存储长文本，比如公司介绍")
  @Column(name = "type_value_text", columnDefinition = "text COMMENT '属性值，存储长文本，比如公司介绍'")
  private String typeValueText;

  @ApiModelProperty("预留字段1")
  @Column(name = "reserved_fields_one", length = 64, columnDefinition = "VARCHAR(64) COMMENT '预留字段1'")
  private String reservedFieldsOne;

  @ApiModelProperty("预留字段2")
  @Column(name = "reserved_fields_two", length = 64, columnDefinition = "VARCHAR(64) COMMENT '预留字段2'")
  private String reservedFieldsTwo;
}
