package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author hupan
 * @date 2023/6/29 10:58
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TaskingAdvisorInviteRecord", description = "品鉴顾问邀请记录表")
@Entity
@TableName("mms_tasking_advisor_invite_record")
@Table(name = "mms_tasking_advisor_invite_record")
@org.hibernate.annotations.Table(appliesTo = "mms_tasking_advisor_invite_record", comment = "品鉴顾问邀请记录表")
public class TaskingAdvisorInviteRecord extends TenantFlagOpEntity {

  @ApiModelProperty("会员编码")
  @Column(name="member_code" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '会员编码'")
  private String memberCode;

  @ApiModelProperty("会员名称")
  @Column(name = "member_name",length = 100, columnDefinition = "VARCHAR(100) COMMENT '会员姓名'")
  private String memberName;

  @ApiModelProperty("会员手机号")
  @Column(name="member_phone", length = 20, columnDefinition = "VARCHAR(20) COMMENT '会员手机号'")
  private String memberPhone;

  @ApiModelProperty("会员成长值")
  @Column(name = "current_grow", length = 11, columnDefinition = "int(11) COMMENT '会员成长值'")
  private Integer currentGrow;

  @ApiModelProperty("会员累计成长值")
  @Column(name = "accumulate_grow", length = 11, columnDefinition = "int(11) COMMENT '会员累计成长值'")
  private Integer accumulateGrow;

  @ApiModelProperty("注册时间")
  @TableField(value = "member_register")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "member_register", length = -1, columnDefinition = "datetime COMMENT '注册时间'")
  private Date memberRegister;

  @ApiModelProperty("品鉴顾问编码")
  @Column(name="tasting_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '品鉴顾问编码'")
  private String tastingCode;

  @ApiModelProperty("品鉴顾问名称")
  @Column(name="tasting_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '品鉴顾问名称'")
  private String tastingName;

  @ApiModelProperty("品鉴顾问手机号")
  @Column(name="tasting_phone", length = 20, columnDefinition = "VARCHAR(20) COMMENT '品鉴顾问手机号'")
  private String tastingPhone;

  @ApiModelProperty("关联组织编码")
  @Column(name="link_org_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '关联组织编码'")
  private String linkOrgCode;

  @ApiModelProperty("关联组织")
  @Column(name="link_org_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '关联组织'")
  private String linkOrgName;
}
