package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 品鉴顾问实体类
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/13 10:03
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TastingConsultant", description = "品鉴顾问实体类")
@Entity
@TableName("mms_tasting_consultant")
@Table(
        name = "mms_tasting_consultant")
@org.hibernate.annotations.Table(appliesTo = "mms_tasting_consultant", comment = "品鉴顾问")
public class TastingConsultant extends TenantFlagOpEntity {

    @ApiModelProperty("品鉴顾问编码")
    @Column(name = "code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '编码'")
    private String code;

    @ApiModelProperty("姓名")
    @Column(name = "name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '姓名'")
    private String name;

    @ApiModelProperty("手机号")
    @Column(name = "phone", length = 11, columnDefinition = "VARCHAR(11) COMMENT '手机号'")
    private String phone;

    @ApiModelProperty("性别")
    @Column(name = "gender", length = 64, columnDefinition = "VARCHAR(64) COMMENT '性别'")
    private String gender;

    @ApiModelProperty("生日")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "birthday",  columnDefinition = "datetime COMMENT '生日'")
    private Date birthday;

    @ApiModelProperty("年龄")
    @Column(name = "age", columnDefinition = "int(3) COMMENT '年龄'")
    private Integer age;

    @ApiModelProperty("单位")
    @Column(name = "company", length = 64, columnDefinition = "VARCHAR(64) COMMENT '单位'")
    private String company;

    @ApiModelProperty("职位")
    @Column(name = "position", length = 64, columnDefinition = "VARCHAR(64) COMMENT '职位'")
    private String position;

    @ApiModelProperty("有效期（开始）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "validate_start_date", length = 64, columnDefinition = "datetime COMMENT '有效期（开始）'")
    private Date validateStartDate;

    @ApiModelProperty("有效期（结束）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "validate_end_date", length = 64, columnDefinition = "datetime COMMENT '有效期（开始）'")
    private Date validateEndDate;

    @ApiModelProperty("累计邀请会员数量")
    @Column(name = "total_member_num", columnDefinition = "decimal(10,0) COMMENT '累计邀请会员数量'")
    private BigDecimal totalMemberNum;

    @ApiModelProperty("累计邀请会员获取成长值")
    @Column(name = "total_growth_value", columnDefinition = "decimal(18,2) COMMENT '累计邀请会员获取成长值'")
    private BigDecimal totalGrowthValue;
}
