package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 品鉴顾问权益实体类
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/13 10:35
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TastingRelBenefits", description = "品鉴顾问权益实体类")
@Entity
@TableName("mms_tasting_rel_benefits")
@Table(
        name = "mms_tasting_rel_benefits")
@org.hibernate.annotations.Table(appliesTo = "mms_tasting_rel_benefits", comment = "品鉴顾问权益实体类")
public class TastingRelBenefits extends TenantFlagOpEntity {

    @ApiModelProperty("品鉴顾问编码")
    @Column(name = "tasting_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '品鉴顾问编码'")
    private String tastingCode;

    @ApiModelProperty("权益编码")
    @Column(name = "benefits_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '权益编码'")
    private String benefitsCode;

    @ApiModelProperty("权益编码")
    @Column(name = "benefits_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '权益名称'")
    private String benefitsName;

    @ApiModelProperty("权益类型CODE")
    @Column(name = "benefits_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '权益类型CODE'")
    private String benefitsType;

    @ApiModelProperty("权益类型NAME")
    @Column(name = "benefits_type_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '权益类型NAME'")
    private String benefitsTypeName;

    @ApiModelProperty("数量")
    @Column(name = "quantity", columnDefinition = "int(10) COMMENT '权益类型NAME'")
    private Integer quantity;

    @ApiModelProperty("发放频次CODE")
    @Column(name = "delivery_frequency", length = 64, columnDefinition = "VARCHAR(64) COMMENT '发放频次CODE'")
    private String deliveryFrequency;

    @ApiModelProperty("发放频次Name")
    @Column(name = "delivery_frequency_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '发放频次Name'")
    private String deliveryFrequencyName;
}
