package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 品鉴关联客户实体类
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/13 10:29
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TastingRelCustomer", description = "品鉴关联客户实体类")
@Entity
@TableName("mms_tasting_rel_customer")
@Table(
        name = "mms_tasting_rel_customer")
@org.hibernate.annotations.Table(appliesTo = "mms_tasting_rel_customer", comment = "品鉴顾问关联客户信息")
public class TastingRelCustomer extends TenantFlagOpEntity {


    @ApiModelProperty("品鉴顾问编码")
    @Column(name = "tasting_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '品鉴顾问编码'")
    private String tastingCode;

    @ApiModelProperty("组织编码")
    @Column(name = "org_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '组织编码'")
    private String orgCode;

    @ApiModelProperty("组织名称")
    @Column(name = "org_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '组织名称'")
    private String orgName;

    @ApiModelProperty("单位类型")
    @Column(name = "org_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '单位类型'")
    private String orgType;


}
