package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 核销角色
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/26 15:55
 **/

@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "VerificationRole", description = "核销角色")
@Entity
@TableName("mms_role")
@Table(
        name = "mms_role")
@org.hibernate.annotations.Table(appliesTo = "mms_role", comment = "核销角色")
public class VerificationRole extends TenantFlagOpEntity {

    @ApiModelProperty("角色编码")
    @Column(name = "role_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '角色编码'")
    private String roleCode;

    @ApiModelProperty("角色名称")
    @Column(name = "role_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '角色名称'")
    private String roleName;


}
