package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 核销用户
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/26 16:27
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "verificationUser", description = "核销用户")
@Entity
@TableName("mms_verification_user")
@Table(
        name = "mms_verification_user")
@org.hibernate.annotations.Table(appliesTo = "mms_verification_user", comment = "核销用户")
public class VerificationUser extends TenantFlagOpEntity {

    @ApiModelProperty("核销人员编码")
    @Column(name = "user_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '核销人员编码'")
    private String userCode;

    @ApiModelProperty("核销人员姓名")
    @Column(name = "user_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '核销人员姓名'")
    private String userName;

    @ApiModelProperty("角色编码")
    @Column(name = "role_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '角色编码'")
    private String roleCode;

    @ApiModelProperty("角色名称")
    @Column(name = "role_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '角色名称'")
    private String roleName;

    @ApiModelProperty("组织编码")
    @Column(name = "org_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '组织编码'")
    private String orgCode;

    @ApiModelProperty("组织名称")
    @Column(name = "org_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '组织名称'")
    private String orgName;

    @ApiModelProperty("手机号")
    @Column(name = "phone", length = 64, columnDefinition = "VARCHAR(64) COMMENT '手机号'")
    private String phone;

    @ApiModelProperty("人员类型,数据字典:mms_verification_user_type 枚举:VerificationUserTypeEnum")
    @Column(name = "user_type", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '人员类型'")
    private String userType;
}
