package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * 轮播图实体
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/15 09:44
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ViewpagerEntity", description = "轮播图实体")
@Entity
@TableName("mms_viewpager")
@Table(
        name = "mms_viewpager")
@org.hibernate.annotations.Table(appliesTo = "mms_viewpager", comment = "轮播图")
public class ViewpagerEntity extends TenantFlagOpEntity {


    @ApiModelProperty("编码")
    @Column(name = "code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '编码'")
    private String code;

    @Column(name = "sort_index", nullable = false,columnDefinition = "INT(7) COMMENT '序号'")
    @ApiModelProperty("序号")
    private Integer sortIndex;

    @ApiModelProperty("开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "start_date",nullable = false, length = 64, columnDefinition = "datetime COMMENT '开始时间'")
    private Date startDate;

    @ApiModelProperty("结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "end_date", nullable = false,length = 64, columnDefinition = "datetime COMMENT '结束时间'")
    private Date endDate;

    @ApiModelProperty("应用区域")
    @Column(name = "use_area",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '应用区域'")
    private String useArea;

    @ApiModelProperty("应用区域")
    @Column(name = "use_area_name",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '应用区域'")
    private String useAreaName;

    @ApiModelProperty("跳转")
    @Column(name = "skip_type",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '应用区域'")
    private String skipType;

    @ApiModelProperty("跳转")
    @Column(name = "skip_type_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '应用区域'")
    private String skipTypeName;

    @ApiModelProperty("跳转url")
    @Column(name = "skip_url", length = 64, columnDefinition = "VARCHAR(64) COMMENT '跳转url'")
    private String skipUrl;

    @ApiModelProperty("小程序id")
    @Column(name = "app_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '小程序id'")
    private String appId;

    @ApiModelProperty("图片编码")
    @Column(name = "main_file_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '图片编码'")
    private String mainFileCode;

}
