package com.biz.crm.member.business.member.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 轮播图片
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/15 10:01
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ViewpagerFile", description = "轮播图片")
@Entity
@TableName("mms_viewpager_file")
@Table(
        name = "mms_viewpager_file")
@org.hibernate.annotations.Table(appliesTo = "mms_viewpager_file", comment = "轮播图片")
public class ViewpagerFile extends TenantFlagOpEntity {

    @ApiModelProperty("轮播图主信息编码")
    @Column(name = "viewpager_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '轮播图主信息编码'")
    private String viewpagerCode;

    /** 相对路径 */
    @Column(name = "relative_path", columnDefinition = "VARCHAR(255) COMMENT ' 相对路径 '")
    @ApiModelProperty("相对路径")
    private String relativePath;

    /** 文件名 */
    @Column(name = "file_id", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 文件id '")
    @ApiModelProperty("文件id")
    private String fileId;

    /** 文件名 */
    @Column(name = "file_name", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 文件名 '")
    @ApiModelProperty("文件名")
    private String fileName;

    /** 图片类型 */
    @Column(name = "type", nullable = true, columnDefinition = "VARCHAR(255) COMMENT ' 图片类型 '")
    @ApiModelProperty("图片类型")
    private String type;

    /** 是主图 */
    @Column(name = "main_image", nullable = false, columnDefinition = "tinyint(1) COMMENT ' 是主图 '")
    @ApiModelProperty("是主图")
    @JsonProperty(value = "mainImage")
    private Boolean mainImage;

    @Column(name = "sort_index", nullable = false,columnDefinition = "INT(7) COMMENT '排序（按数字顺序排列）'")
    @ApiModelProperty("排序（按数字顺序排列）")
    private Integer sortIndex;
}
