package com.biz.crm.member.business.member.local.helper;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.member.business.member.local.utils.AssertUtils;
import com.biz.crm.member.business.member.sdk.vo.login.MemberUserDetails;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 统一用户获取
 */
@Component
public class UserSearchHelper {

  @Autowired(required = false)
  private LoginUserService loginUserService;

  /**
   * 返回用户类型 UserTypeEnum
   *
   * @return
   */
  public String getUserType() {
    UserIdentity loginDetails = loginUserService.getLoginDetails(UserIdentity.class);
    AssertUtils.isNotNull(loginDetails, "当前用户登陆信息不存在,请重新登陆");
    String identityType = loginDetails.getIdentityType();
    return identityType;
  }

  /**
   * 获取登录账号
   *
   * @return
   */
  public String getAccount() {
    UserIdentity loginDetails = loginUserService.getLoginUser();
    AssertUtils.isNotNull(loginDetails, "当前用户登陆信息不存在,请重新登陆");
    String account = loginDetails.getAccount();
    return account;
  }

  /**
   * 获取企业用户的真实名字
   *
   * @return
   */
  public String getCrmRealName() {
    AbstractCrmUserIdentity loginUser = loginUserService.getAbstractLoginUser();
    AssertUtils.isNotNull(loginUser, "当前用户登陆信息不存在,请重新登陆");
    return loginUser.getRealName();
  }

  /**
   * member用户信息 - 小程序取用户信息
   *
   * @return
   */
  public MemberUserDetails getMemberLogin() {
    MemberUserDetails loginDetails = loginUserService.getLoginDetails(MemberUserDetails.class);
    AssertUtils.isNotNull(loginDetails, "当前用户登陆信息不存在,请重新登陆");
    return loginDetails;
  }

    /**
     * user用户信息 - 后台取用户信息
     *
     * @return
     */
    public UserIdentity getUserLogin() {
        UserIdentity loginDetails = loginUserService.getLoginDetails(UserIdentity.class);
        AssertUtils.isNotNull(loginDetails, "当前用户登陆信息不存在,请重新登陆");
        return loginDetails;
    }
}
