package com.biz.crm.member.business.member.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.local.entity.ActivityManage;
import com.biz.crm.member.business.member.sdk.dto.ActivityManagePageDto;
import com.biz.crm.member.business.member.sdk.vo.ActivityManagePageVo;
import org.apache.ibatis.annotations.Param;

/**
 * 活动管理 数据访问层
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/16 14:19
 **/
public interface ActivityManageMapper extends BaseMapper<ActivityManage> {

    /**
     * 后台分页查询活动管理
     * @param page
     * @param activityManageDto
     * @return
     */
    Page<ActivityManagePageVo> findByConditions(@Param("page") Page<ActivityManagePageVo> page, @Param("dto") ActivityManagePageDto activityManageDto); /**


     * 小程序分页查询活动企划
     * @param page
     * @param activityManageDto
     * @return
     */
    Page<ActivityManagePageVo> findByConditionsByApplet(@Param("page") Page<ActivityManagePageVo> page, @Param("dto") ActivityManagePageDto activityManageDto);


    /*
    * 活动详情
    */
    ActivityManage getActById(@Param("dto") ActivityManagePageDto activityManageDto);
}
