package com.biz.crm.member.business.member.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.local.entity.AnswerRecord;
import com.biz.crm.member.business.member.sdk.dto.AnswerRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.AnswerRecordVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionCountVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionStatisticVo;
import java.util.List;
import org.apache.ibatis.annotations.Param;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/21 15:13
 * @description 用户答题记录(AnswerRecord)表操作层
 */
public interface AnswerRecordMapper extends BaseMapper<AnswerRecord> {

  /**
   * 统计题目答案个数
   *
   * @param questionCodes
   * @return
   */
  List<QuestionStatisticVo> statisticQuestion(@Param("questionCodes") List<String> questionCodes,
      @Param("delFlag") String delFlag);

  /**
   * 根据题目编码分页获取答题记录
   * @param page
   * @param dto
   * @return
   */
  Page<AnswerRecordVo> pageAnswerRecord(Page<AnswerRecordVo> page,@Param("dto") AnswerRecordPaginationDto dto,
      @Param("delFlag") String delFlag);

}
