package com.biz.crm.member.business.member.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.local.entity.Discuss;
import com.biz.crm.member.business.member.sdk.dto.DiscussPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.DiscussVo;
import com.biz.crm.member.business.member.sdk.vo.InfoCountDto;
import java.util.List;
import org.apache.ibatis.annotations.Param;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/19 14:05
 * @description 评论管理(Discuss)表操作层
 */
public interface DiscussMapper extends BaseMapper<Discuss> {

  /**
   * 分页获取评论信息
   *
   * @param page
   * @param dto
   * @return
   */
  Page<DiscussVo> pageDiscussInfo(Page<DiscussVo> page, @Param("dto") DiscussPaginationDto dto,
      @Param("delFlag") String delFlag);

  /**
   * 分组统计评论量
   *
   * @param infoCodes
   * @return
   */
  List<InfoCountDto> countByInfoCode(@Param("infoCodes") List<String> infoCodes,
      @Param("delFlag") String delFlag,
      @Param("checkStatus") String checkStatus,
      @Param("enableStatus") String enableStatus);

  /**
   * 小程序分页获取资讯的评论信息
   *
   * @param page
   * @param infoCode
   * @param memberCode
   * @return
   */
  Page<DiscussVo> appPageDiscussByInfoCode(Page<DiscussVo> page,
      @Param("infoCode") String infoCode,
      @Param("memberCode") String memberCode,
      @Param("delFlag") String delFlag,
      @Param("checkStatus") String checkStatus,
      @Param("enableStatus") String enableStatus);
}
