package com.biz.crm.member.business.member.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.dto.AppOrderPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.DummyOrderVo;
import com.biz.crm.member.business.member.local.entity.DummyOrder;
import com.biz.crm.member.business.member.sdk.dto.DummyOrderPaginationDto;
import org.apache.ibatis.annotations.Param;

/**
 * 虚拟订单(DummyOrder)表数据库访问层
 *
 * @author zouhs
 * @date 2023-06-14 15:00:59
 */
public interface DummyOrderMapper extends BaseMapper<DummyOrder> {
  
  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<DummyOrderVo> findByConditions(
      Page<DummyOrderVo> page, @Param("dto") DummyOrderPaginationDto dto);

  /**
   * 小程序分页获取虚拟订单
   * @param page
   * @param dto
   * @param memberCode
   * @param delFlag
   * @return
   */
  Page<DummyOrderVo> appPageDummyOrder(Page<DummyOrderVo> page,
      @Param("dto") AppOrderPaginationDto dto,
      @Param("memberCode") String memberCode,
      @Param("delFlag") String delFlag);
}

