package com.biz.crm.member.business.member.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.DummyOrderApplyUserVo;
import com.biz.crm.member.business.member.sdk.vo.DummyOrderUserVo;
import com.biz.crm.member.business.member.local.entity.DummyOrderUser;
import com.biz.crm.member.business.member.sdk.dto.DummyOrderUserPaginationDto;
import org.apache.ibatis.annotations.Param;

/**
 * 虚拟订单用户信息(DummyOrderUser)表数据库访问层
 *
 * @author zouhs
 * @date 2023-06-14 15:01:25
 */
public interface DummyOrderUserMapper extends BaseMapper<DummyOrderUser> {
  
  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<DummyOrderUserVo> findByConditions(
      Page<DummyOrderUserVo> page, @Param("dto") DummyOrderUserPaginationDto dto);

  /**
   * 用户报名记录
   * @param page
   * @param dto
   * @return
   */
  Page<DummyOrderApplyUserVo> findDummyOrderUserApplyByConditions(Page<DummyOrderApplyUserVo> page,@Param("dto") DummyOrderUserPaginationDto dto);
}

