package com.biz.crm.member.business.member.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.local.entity.InfoCategory;
import com.biz.crm.member.business.member.sdk.dto.InfoCategoryPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.InfoCategoryVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/16 10:53
 * @description 资讯分类管理(InfoCategory)表数据库访问层
 */
@Repository
public interface InfoCategoryMapper extends BaseMapper<InfoCategory> {

  /**
   * 分页获取资讯分类信息
   * @param paginationDto
   * @param page
   * @return
   */
  Page<InfoCategoryVo> pageInfoCategory(@Param("dto") InfoCategoryPaginationDto paginationDto,
      Page<InfoCategoryVo> page, @Param("delFlag") String delFlag);
}
